@echo off
setlocal EnableExtensions
rem Hotfix patch tool v1.5 - HF 1181214

Rem Allow bat file starting from UNC path
pushd %~dp0
cls

rem goto verify

Rem Check if correct client version is installed
reg query "HKCU\Software\SolidWorks\Applications\PDMWorks Enterprise" /v "FileExtVer" |find "30.5" >nul
if %errorlevel% EQU 1 (goto WrongVersion)
goto CheckFiles

:WrongVersion
Echo ----------------------
Echo Failed to determine installed version
Echo ----------------------
Rem Ignore if started in Quiet mode
if(%1)==(Q) (Goto CheckFiles)
if(%1)==(q) (Goto CheckFiles)
Echo Hotfix can only be installed on a SOLIDWORKS PDM 2022 SP5 system.
Echo Only continue if you are certain that this version is installed.
Echo ----------------------
SET /P ANSWER=Do you want to continue (y/n)?
if /i {%ANSWER%}=={y} (goto CheckFiles)
if /i {%ANSWER%}=={yes} (goto CheckFiles)
if /i {%ANSWER%}=={Y} (goto CheckFiles)
if /i {%ANSWER%}=={YES} (goto CheckFiles)
goto QuietCheck

:CheckFiles
Rem Check that patch source DLLs are found
if NOT exist ".\x32\NameSpace.dll" (goto FileMissing)
if NOT exist ".\x64\NameSpace.dll" (goto FileMissing)

goto FileOk

:FileMissing
Echo ------------------------------
Echo Script cannot find hotfix files. 
Echo Please verify all files and folders included with hotfix are present.
Echo ------------------------------
Rem check if started in Quiet mode
if(%1)==(Q) (Goto End)
if(%1)==(q) (Goto End)
Pause
exit

:FileOk


Echo SOLIDWORKS PDM Hotfix patch tool
if(%1)==(Q) (Goto GoOn)
if(%1)==(q) (Goto GoOn)
Rem Show warning
Echo --------------------------------
Echo This script will replace SOLIDWORKS PDM program files on the system.
Echo If the files are loaded in memory by applications, those applications will be
Echo closed automatically. If any SOLIDWORKS PDM services are also running, 
Echo those will be restarted if needed. It is recommended you stop them manually.
Echo Please make sure you have saved any work in case the application is closed.
Echo --------------------------------
SET /P ANSWER=Do you want to continue (y/n)?
if /i {%ANSWER%}=={y} (goto GoOn)
if /i {%ANSWER%}=={yes} (goto GoOn)
if /i {%ANSWER%}=={Y} (goto GoOn)
if /i {%ANSWER%}=={YES} (goto GoOn)
exit

:GoOn

set DbServerStopped=0
set ArchiveServerStopped=0

Rem Check if database server service is running and stop it
tasklist /v |findstr ConisioDbServer.exe >nul
IF %errorlevel% EQU 0 (
Echo ---------------------------------------------------
Echo Please wait - trying to stop database server service
Net stop ConisioDbServer
set DbServerStopped=1
)


Rem Check if archiveserver service is running and stop it
tasklist /v |findstr ArchiveServerService.exe >nul
IF %errorlevel% EQU 0 (
Echo ---------------------------------------------------
Echo Please wait - trying to stop archive server service
Net stop ArchiveServerService
set ArchiveServerStopped=1
)

Rem Kill processes holding on to SW PDM DLLs
Echo ---------------------------------------------------------
Echo Kill processes holding on to DLLs to be replaced...

Rem first DLL
tasklist /m NameSpace.dll /nh |findstr NameSpace.dll >nul
IF %errorlevel% EQU 0 (
FOR /F "tokens=2" %%A IN ('tasklist /m NameSpace.dll /fo TABLE /nh') DO (taskkill /PID:%%A /F)
)

Rem Get SW PDM install location
FOR /F "tokens=2* delims=	 " %%A IN ('reg query "HKLM\Software\SolidWorks\Applications\PDMWorks Enterprise" /v "Location"') DO SET InstallFolder=%%B

Rem Get SW PDM x32 install location
FOR /F "tokens=2* delims=	 " %%A IN ('reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\SolidWorks\Applications\PDMWorks Enterprise" /v "Location"') DO SET InstallFolderx86=%%B

Echo --------------------
Echo Backup DLLs...
Echo to "%Temp%\SWPDMDllBackup"
if NOT exist "%Temp%\SWPDMDllBackup\x64" mkdir "%Temp%\SWPDMDllBackup\x64"
if NOT exist "%Temp%\SWPDMDllBackup\x32" mkdir "%Temp%\SWPDMDllBackup\x32"

Rem 64-bit files
Echo from "%InstallFolder%NameSpace.dll"
COPY /Y "%InstallFolder%NameSpace.dll" "%Temp%\SWPDMDllBackup\x64\NameSpace.dll"

Rem 32-bit files
Echo from "%InstallFolderx86%NameSpace.dll"
COPY /Y "%InstallFolderx86%NameSpace.dll" "%Temp%\SWPDMDllBackup\x32\NameSpace.dll"


Echo ---------------------
Echo Replace DLLs...

Rem 64-bit files
Echo Replace "%InstallFolder%NameSpace.dll"
COPY /Y ".\x64\NameSpace.dll" "%InstallFolder%NameSpace.dll"

Rem 32-bit files
Echo Replace "%InstallFolderx86%NameSpace.dll"
COPY /Y ".\x32\NameSpace.dll" "%InstallFolderx86%NameSpace.dll"


:verify

Rem Verify replaced files

Echo --------------------------
Echo Verifying replaced files...
set CompareErrorFlag=0

Rem 64-bit files
fc /b ".\x64\NameSpace.dll" "%InstallFolder%NameSpace.dll" > nul 
if errorlevel 1 (set CompareErrorFlag=1
echo "%InstallFolder%NameSpace.dll" - Mismatched
) else (echo "%InstallFolder%NameSpace.dll" - OK)

Rem 32-bit files
fc /b ".\x32\NameSpace.dll" "%InstallFolderx86%NameSpace.dll" > nul 
if errorlevel 1 (set CompareErrorFlag=1
echo "%InstallFolderx86%NameSpace.dll" - Mismatched
) else (echo "%InstallFolderx86%NameSpace.dll" - OK)

if %CompareErrorFlag%==0 goto Done

:CompareError
Echo ----------------------
Echo Hotfix failed - One or more replaced files are mismatched.
echo Close all applications and try running Hotfix installer again.
Echo ----------------------
goto RestartProcess

:Done
Echo ----------------------
Echo Done - Hotfix applied
Echo ----------------------

:RestartProcess
Rem restart explorer.exe if not running
tasklist /v |findstr explorer.exe >nul
IF %errorlevel% EQU 1 (
Echo --------------------------
Echo Starting Explorer... 
start explorer.exe)

Rem start services if previously stopped
if %ArchiveServerStopped% EQU 1 (
Echo ---------------------------------------------------
Echo Please wait - trying to start archive server service
net start ArchiveServerService
)
if %DbServerStopped% EQU 1 (
Echo ---------------------------------------------------
Echo Please wait - trying to start database server service
net start ConisioDbServer
)

:QuietCheck
Rem check if started in Quiet mode
if(%1)==(Q) (Goto End)
if(%1)==(q) (Goto End)
Pause

:END